﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using ComiDll;
using System.Runtime.InteropServices;

namespace ADCcon
{
    public partial class Form1 : Form
    {
        IntPtr g_hDevice = IntPtr.Zero;
        public bool g_bScanStart = false;
        public const int BufSize = 10240;
        public bool single1 = true;
        public const int CH_NUM = 6; // AD 스캔을 원하는 채널 개수

        double[] g_fData = new double[1000];

        public enum CHLIST
        {
            CH0, CH1, CH2, CH3, CH4, CH5
        }

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            g_hDevice = CDDLL.COMI_LoadDevice((int)CDDLL.TCmDeviceID.COMI_SD101, 0);

            if (g_hDevice == IntPtr.Zero) MessageBox.Show("Device CP201 로드 실패");
        }

        private void BtnStop_Click(object sender, EventArgs e)
        {
            CDDLL.COMI_US_Stop(g_hDevice, 1);
            g_bScanStart = false;
        }

        private void CmbCh_SelectedIndexChanged(object sender, EventArgs e)
        {
            axComiGraph1.TargetChannel = 0;
            axComiGraph1.ChannelTitle = CmbCh.Text;
            axComiGraph1.RefreshAll();
        }

        private void EdtFreq_TextChanged(object sender, EventArgs e)
        {
            //if (EdtFreq.Text.Length==0)
            //{
            //    EdtFreq.Text = convert.100;
            //}
            //else if (EdtFreq.Text > 1000)
            //{
            //    EdtFreq.Text = "1000";
            //}
            //else if (EdtFreq.Text < 0)
            //{
            //    EdtFreq.Text = "100";
            //}
        }

        private void BtnStart_Click(object sender, EventArgs e)
        {
            int i;
            int ScanFreq = Convert.ToInt32(this.EdtFreq.Text);
            int nResult;

            int []ChannelList = new int [CH_NUM];

            for (i = 0; i< CH_NUM; i++)
            {
                ChannelList[i] = i;
            }

            try
            {
                nResult = CDDLL.COMI_US_Start(g_hDevice, CH_NUM, ChannelList, ScanFreq, BufSize, (int)CDDLL.TCdAiScanTrs.cmTRS_BLOCK);

                if (nResult > 0) // nResult 는 적용된 scan freq 를 반환
                {
                    g_bScanStart = true;
                }
                else
                {
                    MessageBox.Show("Aiscan 이 정상적으로 수행되지 않음");
                }
            }
            catch
            {
                MessageBox.Show("Aiscanstart함수오류 발생");
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {

            if (!g_bScanStart) return;

            IntPtr repsPtr;

            CDDLL.ScanData scandata = new CDDLL.ScanData();
            scandata.fData = new double[1000];

            //repsPtr = Marshal.AllocHGlobal(Marshal.SizeOf(typeof(CDDLL.ScanData)));
            repsPtr = Marshal.AllocCoTaskMem(Marshal.SizeOf(typeof(CDDLL.ScanData)));
            Marshal.StructureToPtr(scandata, repsPtr, false);

            for(int i=0; i<1000; i++)
                scandata.fData[i] = 1.0;
            
            int nStartCount = CDDLL.COMI_US_CurCount(g_hDevice);

            int nRetrvCount = CDDLL.COMI_US_RetrvChannel(g_hDevice, (int)CHLIST.CH0, 0, 1000, repsPtr, (int)CDDLL.TCdVarType.VT_DOUBLE);

            CDDLL.ScanData reps = new CDDLL.ScanData();

            reps = (CDDLL.ScanData)Marshal.PtrToStructure(repsPtr, typeof(CDDLL.ScanData));

            // reps.fData 가 최신 데이터임

            if (nRetrvCount > 0)
            {
                // 그래프에 표시
                axComiGraph1.DeletePlot(0);
                axComiGraph1.PlotY(0, ref scandata.fData[0], 0, 1, nRetrvCount);
                axComiGraph1.UpdatePlot();
            }

            Marshal.FreeCoTaskMem(repsPtr);
            //Marshal.FreeHGlobal(repsPtr);
        }

        private void axComiDaq1_DigitalInStateChanged(object sender, AxCOMIDAQLib._DComiDaqEvents_DigitalInStateChangedEvent e)
        {

        }

        private void CmbRange_SelectedIndexChanged(object sender, EventArgs e)
        {
            double Vmin = 0, Vmax = 0;
            switch (CmbRange.SelectedIndex)
            {
                case 0:
                    Vmin = -1;
                    Vmax = 1;
                    break;

                case 1:
                    Vmin = -2;
                    Vmax = 2;
                    break;

                case 2:
                    Vmin = -5;
                    Vmax = 5;
                    break;

                case 3:
                    Vmin = -10;
                    Vmax = 10;
                    break;
            }

            for (int ch = 0; ch < CH_NUM; ch++)
            {
                CDDLL.COMI_AD_SetRange(g_hDevice, ch, Vmin, Vmax);
            }
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            CDDLL.COMI_UnloadDevice(g_hDevice);
        }
    }
}
